/* 
 *  tincas_lib.mm : tincas interface
 *  Masato ISHIKAWA, Tokyo Institute of Technology
 *  modified by t-kita@eecs.kumamoto-u.ac.jp
 *
 */

#include "tincas2_inc.mm"

Func Integer open_canvas( size, bg, ... )
Matrix size;
String bg;
  {
     Integer pid;
     
     if (nargs==1) {
	  bg = DEFAULT_BG;
     }

//     pid = popen("tincas");
     if       (access("./tincas2")==0){			// t-kita
	  pid = popen("wish ./tincas2");		// t-kita
     }else{						// t-kita
	  pid = popen("tincas2");			// t-kita
	  if (pid<0){					// t-kita
	       error("tincas2 $B$r5/F0$G$-$^$;$s!#(B\n");	// t-kita
	  }						// t-kita
     }							// t-kita
     fprintf( pid, "%d\n%d\n%s\n\n", Integer(size(1)), Integer(size(2)), bg);
     _canvas_size = size;	// t-kita
     auto_clear_interval= AUTO_CLEAR_INTERVAL_DEFAULT;
     return(pid);
  }

Func void close_canvas( pid )
Integer pid;
  {
     fprintf(pid, ".\n");
     pclose(pid);
  }

Func void line( pid, points, options, ... )
Integer pid;
Matrix points;
String options;
  {
     Integer i,j; 
     
     if (nargs==2) {
	  options="-fill " + DEFAULT_FG;
     }

     /* $BD9$9$.$k$H$-$OE,Ev$K@Z$j$^$7$g$&(B */
     /* $BC<E@=hM}$N$?$a!$(B2$B$r0z$$$F$+$i3d$k$3$H$KCm0U(B */
     for ( i=0; i<= ((Rows(points)-2)/MAXPOINTS); i++ ) {  
	fprintf(pid, ".viewer create line ");
	for ( j=i*MAXPOINTS+1; j<= min( (i+1)*MAXPOINTS+1, Rows(points)); j++) {
	   fprintf(pid,"%d %d ", 
		   Integer(points(j,1))+LEFTMARGIN, Integer(points(j,2))+TOPMARGIN );
	}
	fprintf(pid, "%s\n", options);
     }	
  }

Func void pset( pid, pos, c, ... )
Integer pid;
Matrix pos; 
String c;
{
     if (nargs==2) {
	  c = DEFAULT_FG;
     }

     c= c+" -tags tag_p "; // clear $B$9$k$H$-$N$?$a$N%?%0(B
	  
     fprintf(pid,".viewer create line %d %d %d %d -fill %s\n", 
	     Integer(pos(1))+LEFTMARGIN,   Integer(pos(2))+TOPMARGIN, 
	     Integer(pos(1))+LEFTMARGIN+1, Integer(pos(2))+TOPMARGIN+1, c);
}

Func void polygon( pid, points, options, ... )
Integer pid;
Matrix points;
String options;
  {
     Integer i; 
     
     if (nargs==2) {
	  options="-outline " + DEFAULT_FG;
     }

     fprintf(pid, ".viewer create polygon ");
     for(i=1; i<=Rows(points); i++) {
	fprintf(pid,"%d %d ", 
		Integer(points(i,1))+LEFTMARGIN, Integer(points(i,2))+TOPMARGIN );
     }
     fprintf(pid, "%s\n", options);
}	

Func void box( pid, points, options, ... )
Integer pid;
Matrix points;
String options;
{
     if (nargs==2) {
	  options="-outline " + DEFAULT_FG;
     }

     if ((Rows(points)!=2) || (Cols(points)!=2) ) {
	warning("box : Ilegal point specification\n");
     } else {
	fprintf(pid, ".viewer create rectangle ");
	fprintf(pid,"%d %d %d %d ", 
		Integer(points(1,1))+LEFTMARGIN, Integer(points(1,2))+TOPMARGIN,
		Integer(points(2,1))+LEFTMARGIN, Integer(points(2,2))+TOPMARGIN );
	fprintf(pid, "%s\n", options);
     }
}	

Func void arc( pid, points, options, ... )
Integer pid;
Matrix points;
String options;
{
     if (nargs==2) {
	  options="-outline " + DEFAULT_FG;
     }

     if ((Rows(points)!=2) || (Cols(points)!=2) ) {
	warning("arc : Ilegal point specification\n");
     } else {
	fprintf(pid, ".viewer create arc ");
	fprintf(pid,"%d %d %d %d ", 
		Integer(points(1,1))+LEFTMARGIN, Integer(points(1,2))+TOPMARGIN,
		Integer(points(2,1))+LEFTMARGIN, Integer(points(2,2))+TOPMARGIN );
	fprintf(pid, "%s\n", options);
     }
}	

Func void circle( pid, center, radius, options, ... )
Integer pid;
Matrix center;
Real radius; 
String options;
{
     Integer i; 

     if (nargs==3) {
	  options="-outline " + DEFAULT_FG;
     }

     fprintf(pid, ".viewer create oval ");
     fprintf(pid,"%d %d %d %d ", 
	     Integer( center(1)-radius ) + LEFTMARGIN, 
	     Integer( center(2)-radius ) + TOPMARGIN, 
	     Integer( center(1)+radius ) + LEFTMARGIN, 
	     Integer( center(2)+radius ) + TOPMARGIN
	  );
     fprintf(pid, "%s\n", options);
}	

Func void circle_d( pid, diam, options, ... )
Integer pid;
Matrix diam;
String options;
  {
     Integer i; 

     if (nargs==2) {
	  options="-outline " + DEFAULT_FG;
     }

     circle(pid, (diam(1,:)+diam(2,:))/2, norm([diam(1,:)-diam(2,:)]')/2, options); 
  }

Func void ellipse( pid, center, radii, options, ... )
Integer pid;
Matrix center, radii;
String options;
  {
     Integer i; 

     if (nargs==3) {
	  options="-outline " + DEFAULT_FG;
     }

     fprintf(pid, ".viewer create oval ");
     fprintf(pid,"%d %d %d %d ", 
	     Integer( center(1)-radii(1) ) + LEFTMARGIN, 
	     Integer( center(2)-radii(2) ) + TOPMARGIN, 
	     Integer( center(1)+radii(1) ) + LEFTMARGIN, 
	     Integer( center(2)+radii(2) ) + TOPMARGIN
	  );
     fprintf(pid, "%s\n", options);
}	

Func void ellipse_d( pid, points, options, ... )
Integer pid;
Matrix points;
String options;
{
     Integer i; 

     if (nargs==2) {
	  options="-outline " + DEFAULT_FG;
     }

     fprintf(pid, ".viewer create oval ");
     fprintf(pid,"%d %d %d %d ", 
	     Integer( points(1,1) ) + LEFTMARGIN, 
	     Integer( points(1,2) ) + TOPMARGIN, 
	     Integer( points(1,1) ) + LEFTMARGIN, 
	     Integer( points(2,2) ) + TOPMARGIN
	  );
     fprintf(pid, "%s\n", options);
  }

Func void text( pid, pos, str, options, ...)
Integer pid;
Matrix pos; 
String str;
String options; 
{
     if (nargs==3) {
	  options="-fill " + DEFAULT_FG;
     }

     fprintf(pid, ".viewer create text ");
     fprintf(pid,"%d %d -text %s %s\n", 
	     Integer( pos(1) ) + LEFTMARGIN, Integer( pos(2) ) + TOPMARGIN, 
	     str, options );
  }




/*  some additions by t-kita@eecs.kumamoto-u.ac.jp */

Func void set_canvas_xyrange(xym)
     Matrix xym;
{     
     _xyrange= xym;
}

Func Matrix adjust_xyrange(xym)
     Matrix xym;
{     
     // _xyrange : [xmin,xmax, ymin,ymax]
     Real xwidth, ywidth;

     xwidth= xym(2)-xym(1);
     ywidth= xym(4)-xym(3);

     xym(1) = xym(1) - 0.2*xwidth;
     xym(2) = xym(2) + 0.2*xwidth;
     xym(3) = xym(3) - 0.2*ywidth;
     xym(4) = xym(4) + 0.2*ywidth;

     return xym;
}

Func Matrix get_canvas_xyrange()
{     
     return _xyrange;
}

Func void clear_canvas(pid)
     Integer pid;
{     
     // box(pid,[[0,0][_canvas_size]],"-fill black" );
     fprintf(pid,".viewer delete tag tag_p\n");
     _mes_xyrange= Z(0);	// _mes_xyrange $B$N;E@Z$jD>$7!#(B
}

Func void set_tincas_title(pid,tl)
     Integer pid;
     String tl;
{     
     fprintf(pid,"wm title . \"%s\"\n",tl);
}

Func void set_tincas_update_interval(pid,interval)
     Integer pid, interval;
{     
     fprintf(pid,"set update_interval %d\n",interval);
}


Func void update_mes_xyrange(p)
     Matrix p;
{
     // gxy() $B$KEO$5$l$?:BI8(B p $B$N(B max, min $B$r(B _mes_xyrange $B$K5-O?!#(B
     // _xyrange : [xmin,xmax, ymin,ymax]

     if ( length(_mes_xyrange)<=0 ){
	  _mes_xyrange= [p(1), p(1), p(2), p(2)];
     }else{
	  if ( p(1)<_mes_xyrange(1) ){ _mes_xyrange(1)= p(1); }
	  if ( p(1)>_mes_xyrange(2) ){ _mes_xyrange(2)= p(1); }
	  if ( p(2)<_mes_xyrange(3) ){ _mes_xyrange(3)= p(2); }
	  if ( p(2)>_mes_xyrange(4) ){ _mes_xyrange(4)= p(2); }
     }
}

Func Matrix gxy(p)
     Matrix p;
{
     // gxy() $B$KEO$5$l$?:BI8(B p $B$N(B max, min $B$r(B _mes_xyrange $B$K5-O?$7$?$N$A(B
     // $BJ?LL(B P $B$+$i(B $BJ?LL(B Q $B$X$N<L1F(B ($B%"%U%#%sJQ49(B)$B$r9T$&!#(B
     // _xyrange : [xmin,xmax, ymin,ymax]

     update_mes_xyrange(p);

     return gxy_nominmax(p);
}


Func Matrix gxy_nominmax(p)
     Matrix p;
{
     // $BJ?LL(B P $B$+$i(B $BJ?LL(B Q $B$X$N<L1F(B ($B%"%U%#%sJQ49(B)
     //
     Matrix p1, p2, p3, p4;
     Matrix q1, q2, q3, q4;
     Matrix A, b;
     // _xyrange : [xmin,xmax, ymin,ymax]

/*
 p4    p3         q4    q3 
  +----+	   +----+  
  |$BJQ?t(B|    ->     |$B2hLL(B|  
  |    |	   |    |  
  +----+	   +----+  
 p1    p2	  q1    q2 
*/
     p1 = [_xyrange(1) _xyrange(3)]';
     p2 = [_xyrange(2) _xyrange(3)]';
     p3 = [_xyrange(2) _xyrange(4)]';
     p4 = [_xyrange(1) _xyrange(4)]';

     q1 = [0               _canvas_size(2)]';
     q2 = [_canvas_size(1) _canvas_size(2)]';
     q3 = [_canvas_size(1) 0]';
     q4 = [0              0]';

     // qi = A*pi + b   ->   (qi-qj) = A*(pi-pj)
     A = [q1-q3 q2-q4]/[p1-p3 p2-p4];
     b = q1 - A*p1;
     
     return A*p + b;
}

Func void use_mouse(pid)
     Integer pid;
{     
     fprintf(pid,"bind \n");
}
